/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.renderers;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;

public class ImageCellRenderer
implements CellRenderer,
ImageObserver {
    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        graphics.setFont(cellInfo.getFont());
        graphics.setColor(bl ? cellInfo.getSelectedForeground() : cellInfo.getForeground());
        Point point = this.getAlignmentOffset(cellInfo, object);
        graphics.drawImage((Image)object, point.x, point.y, this);
    }

    public Point getAlignmentOffset(CellInfo cellInfo, Object object) {
        Point point = new Point(0, 0);
        int n = cellInfo.getHorizontalAlignment();
        if (n == 2) {
            point.x += cellInfo.getDrawingArea().width - ((Image)object).getWidth(this);
        } else if (n == 1) {
            point.x += (cellInfo.getDrawingArea().width - ((Image)object).getWidth(this)) / 2;
        }
        n = cellInfo.getVerticalAlignment();
        if (n == 1) {
            point.y += (cellInfo.getDrawingArea().height - ((Image)object).getHeight(this)) / 2;
        } else if (n == 2) {
            point.y += cellInfo.getDrawingArea().height - ((Image)object).getHeight(this);
        }
        return point;
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        if (object == null) {
            return null;
        }
        Image image = (Image)object;
        return new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            default: 
        }
        return true;
    }
}

